#include "h/GenericTypeDefs.h"
#include "h/clock.h"
#include "h/compiler.h"
#include "h/uart.h"


/*
const int monthSecondsConst[12]=
{
31, 
28, 
31, 
30, 
31, 
30, 
31, 
31, 
30, 
31, 
30, 
31 
};
*/

const char monthNames[12][4]
={ 	"Jan",
	"Feb",
	"Mar",
	"Apr",
	"May",
	"Jun",
	"Jul",
	"Aug",
	"Sep",
	"Oct",
	"Nov",
	"Dec"
};

const char weekDays[7][4]
={ 	"Mon",
	"Tue",
	"Wed",
	"Thu",
	"Fri",
	"Sat",
	"Sun",
};

extern long timeSMonth;
extern long timeSWeek;
extern long timeSDay;
extern long timeEMonth;
extern long timeEWeek;
extern long timeEDay;
extern long daylightSavingOffset;

int isLeapYear(int iyear)
{
	// returns TRUE if iyear is a leap year, FALSE otherwise
	int i, j;
	i=(iyear%4);
	if(i!=0)return 0;	// since not divisible by 4
	i=(iyear%100);
	if(i!=0)return 1;
	j=(iyear%400);
	if(j==0)return 1; else return 0;
}

/*
DWORD yearSeconds(int year)
{
	// returns the number of seconds in the year year
	DWORD result;
	
	result = 86400 * 365;
	if(isLeapYear(year))result+= 86400;
	return result;
}

DWORD monthSeconds(int year, int month)
{
	if((month==2)&&(isLeapYear(year)))return (86400*29);
	return (86400*monthSecondsConst[month-1]);
}

void convertEpoch2TimeOld(unsigned long epochTime, TIME_T* dest)
{
	int year;
	int month;
	int day;
	int hours;
	int mins;
	int secs;
    long wday;
	unsigned long x;

	year= EPOCH_YEAR;
	month = 1;
    wday = 3;
    
	while(1)
	{
		x=yearSeconds(year);
		if(epochTime >= x)
		{
		epochTime -= x;
		year++;
		wday+=(x/(long)86400);
		} else break;
	}

	while(1)
	{
		x=monthSeconds(year, month);
		if(epochTime >= x)
		{
			epochTime-=x;
			month++;
			wday+=(x/(long)86400);
		} else break;
	}
	
	day =(unsigned int)(epochTime/(long)86400);
	wday+=day;
	
	epochTime -= ((unsigned long)day * (unsigned long)86400);
	hours = (unsigned int) (epochTime / 3600);
	epochTime -= ((long)hours * (long)3600);
	mins = (unsigned int) (epochTime / 60);
	epochTime -= ((long)mins * (long)60);
	secs = (unsigned int) (epochTime);
	
	dest->wday =(int)(wday%7);
	dest->year= year;
	dest->month = month;
	dest->day = day + 1;
	dest->hours = hours;
	dest->mins = mins;
	dest->secs = secs;
}
*/

const int monthDays[11]=
{
31, 
59, 
90, 
120, 
151, 
181, 
212, 
243, 
273, 
304, 
334, 
};


void convertEpoch2TimeInternal(unsigned long epochTime, TIME_T* dest)
{
    int correction;
    int i;
    int years;
    char month;
    unsigned long day;
    int hours;
    int mins;
    int secs;
    unsigned long x;
    int yday;
    int monthday;
	int wk;
        
    // this function only works for 1970 epoch and only for years before 2100...
    // day is the number of days elapsed
    day = (unsigned long)((unsigned long)epochTime/(unsigned long)86400);
    // x is the remainder
    x = (unsigned long)((unsigned long)epochTime - (unsigned long)86400*(unsigned long)day);
    hours = (int) (x/3600);
    x = x - (unsigned long)3600 * (unsigned long)hours;
    mins = (int) (x/60);
    secs = (int) (x - (unsigned long)60 * (unsigned long)mins);
    years = (int)(((float)day)/(float)365.0);
    // first approximation for years...
    // yday is the day of the year...
    yday=(int)((unsigned long)day - (unsigned long)(((float)365.25*(float)years)+(float)0.25))+1;
    if(years>=131)yday++; // correction for the year 2100 which is not a leap year...
    if(yday<=0)
    { 
    years--; 
    yday+=365; 
    if(isLeapYear(1970+years))yday++;
    }
    if(isLeapYear(1970+years))correction=1; else correction=0;
    i=10;
    while(i>0)
    {
        if(yday > (monthDays[i]+correction))break;
        i--;
    }    
    month=2+i;
    if(yday<=31)month=1;
    if(i==0)correction=0;
    if(month>1)monthday=yday-monthDays[i]-correction; else monthday=yday;
    dest->wday =(int)(((long)day+3)%7);
	dest->year= years;
	dest->month = month;
	dest->day = monthday;
	dest->hours = hours;
	dest->mins = mins;
	dest->secs = secs;
	wk = ((((long)day-(long)monthday)+4)%7);			// this is now the day of the week of the 1st of this month.
	dest->first= wk;
	wk = ((7 + dest->wday - wk) % 7);			        // now k is the day of the month of the first wday of the month
	dest->week = ((dest->day - wk)/7)+1;				// dest->week = 1 for the 1st wday of the month, 2 for the second wday of the month and so on (ranges from 1 to 5).
}

int compareMWD(int month, int week, int day, int hour, int first, int month2, int week2, int day2, int hour2)
{
	// returns -1 if first triplet is before 
	// returns 0 if equal
	// returns 1 if first triplet is after second
	int d, d2;

	d= ((7+day-first)%7) + 7*(week-1)+1;
	d2= ((7+day2-first)%7) + 7*(week2-1)+1;
	if(month>month2)return 1;
	else
	if(month==month2)
	{
		if(d>d2)return 1;
		else
		if(d==d2)
		{
			if(hour>hour2)return 1;
			else 
			if(hour==hour2)return 0;
			else return -1;
		}
		else
		return -1;
	} else
	return -1;
}

long daylightSaving(TIME_T timeBase)
{
	int month1;
	int week1;
	int day1;
	int month2;
	int week2;
	int day2;
	int inv;
	int t, t2;

	if(timeSMonth>timeEMonth)
	{
	month1=timeEMonth;
	week1=timeEWeek;
	day1=timeEDay;
	month2=timeSMonth;
	week2=timeSWeek;
	day2=timeSDay;
	inv=0;
	} else
	{
	month1=timeSMonth;
	week1=timeSWeek;
	day1=timeSDay;
	month2=timeEMonth;
	week2=timeEWeek;
	day2=timeEDay;
	inv=1;
	}
	t=compareMWD(timeBase.month, timeBase.week, timeBase.wday, timeBase.hours, timeBase.first, month1, week1, day1, 2);
	t2=compareMWD(timeBase.month, timeBase.week, timeBase.wday, timeBase.hours, timeBase.first, month2, week2, day2, 2);
	if((t>=0)&&(t2<0))
	return inv;
	else
	return (inv^1);
}

void convertEpoch2Time(unsigned long epochTime, TIME_T* dest)
{
	convertEpoch2TimeInternal(epochTime, dest);
	if(daylightSaving(*dest)){ convertEpoch2TimeInternal(epochTime+daylightSavingOffset, dest); dest->daylightSaving=1; } else dest->daylightSaving=0;
}

void ascTime(BYTE* instr, TIME_T timet)
{
	BYTE* outstr;

	outstr=instr;
	// convert a TIME_T structure to a string...
	*outstr++=weekDays[timet.wday][0];
	*outstr++=weekDays[timet.wday][1];
	*outstr++=weekDays[timet.wday][2];
	*outstr++=' ';
	outstr=uitoa(timet.day, outstr);
	*outstr++=' ';
	*outstr++=monthNames[timet.month-1][0];
	*outstr++=monthNames[timet.month-1][1];
	*outstr++=monthNames[timet.month-1][2];
	*outstr++=' ';
	outstr=(BYTE*)uitoa(timet.year+EPOCH_YEAR, outstr);
	*outstr++=' ';
	outstr=(BYTE*)printADec(timet.hours, outstr);
	*outstr++=':';
	outstr=(BYTE*)printADec(timet.mins, outstr);
	*outstr++=':';
	outstr=(BYTE*)printADec(timet.secs, outstr);
//	if(daylightSaving(timet))*outstr++='+'; else *outstr++='0';
//	*outstr++=' ';
//	outstr=(BYTE*)printADec(timet.week, outstr);
	*outstr++='\0';
}

void ascTimeEpoch(BYTE* outstr, long epochTime)
{
	TIME_T dest;
	convertEpoch2Time(epochTime, &dest);
	ascTime(outstr, dest);
}

void getTimeString(BYTE* outstr)
{
	DWORD x;
	x=SNTPGetSeconds();
	ascTimeEpoch(outstr, x);
}
